%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires(pre): perl(CPAN.pm) perl(Carp.pm) perl(Class/Accessor.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(LWP/Simple.pm) perl(LWP/UserAgent.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Params/Validate.pm) perl(Pod/Usage.pm) perl(Socket.pm) perl(Storable.pm) perl(Test/Dependencies.pm) perl(Test/More.pm) perl(Test/TAP/Model/Visual.pm) perl(YAML.pm) perl(YAML/Syck.pm) perl(base.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 0.05
%define module_name Test-Chimps-Client
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.05
Release: alt1
Summary: Send smoke test results to a server
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/Z/ZE/ZEV/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module simplifies the process of sending smoke test results
(in the form of `Test::TAP::Model's) to a smoke server.

    use Test::Chimps::Client;
    use Test::TAP::Model::Visual;

    chdir "some/module/directory";

    my $model = Test::TAP::Model::Visual->new_with_tests(glob("t/*.t"));

    my $client = Test::Chimps::Client->new(
      server => 'http://www.example.com/cgi-bin/smoke-server.pl',
      model  => $model
    );
    
    my ($status, $msg) = $client->send;
    
    if (! $status) {
      print "Error: $msg\n";
      exit(1);
    }

%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc README Changes examples
%perl_vendor_privlib/T*

%changelog
