# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(IO/All.pm) perl(Test/Run/CmdLine/Iface.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Test-Count
%define upstream_version 0.1105

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_2

Summary:    A standalone command line
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/authors/id/S/SH/SHLOMIF/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Carp.pm)
BuildRequires: perl(Exporter.pm)
BuildRequires: perl(File/Basename.pm)
BuildRequires: perl(File/Copy.pm)
BuildRequires: perl(File/Spec.pm)
BuildRequires: perl(File/Temp.pm)
BuildRequires: perl(Getopt/Long.pm)
BuildRequires: perl(IO/Handle.pm)
BuildRequires: perl(IO/Scalar.pm)
BuildRequires: perl(IPC/Open3.pm)
BuildRequires: perl(Module/Build.pm)
BuildRequires: perl(Parse/RecDescent.pm)
BuildRequires: perl(Socket.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(lib.pm)
BuildRequires: perl(parent.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(warnings.pm)
BuildArch:  noarch
Source44: import.info

%description
Test::Count is a set of perl modules for keeping track of the number of
tests in a test file. It works by putting in comments of the form '# TEST'
(one test), '# TEST*$EXPR' or '# TEST+$EXPR' (both are multiple tests).
Test::Count counts these tests throughout the file and returns all of their
results.

One can put any mathematical expressions (using parentheses, '+', '-', '*',
'/' and '%' there). One can also assign variables using '#
TEST:$myvar=5+6;$second_var=$myvar+3' and later use them in the add to
count expressions. A '$var++' construct is also available.

One can find example test scripts under t/.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Build.PL --installdirs=vendor

./Build

%check
./Build test

%install
./Build install --destdir=%{buildroot}

%files
%doc Changes LICENSE META.json META.yml  README examples
%perl_vendor_privlib/*


%changelog
