%define module_name Test-Expr
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Dump.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Keyword/Declare.pm) perl(List/Util.pm) perl(Test/More.pm) perl(parent.pm) perl(re.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.000011
Release: alt1
Summary: Test an expression with better error messages
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DC/DCONWAY/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This testing module installs a single keyword: `ok'

That keyword evaluates the expression and produces a test report entry
in the usual way (i.e. just like `Test::Simple::ok' or `Test::More::ok').
Except that, if you don't give it a description argument, it uses
the test expression itself as the description.

In addition, the diagnostic message produced if the test fails is
significantly more useful than that provided by either of those other
two modules.

For example, the sample code in the Synopsis
might produce the following report:

    1..5
    ok 1 - $got == $expected
    not ok 2 - $got eq $expected
    #   Failed test '$got eq $expected'
    #   at t/synopsis.t line 13.
    #   because:
    #          $got --> "1.0"
    #     $expected --> 1
    #
    not ok 3 - $got != $expected
    #   Failed test '$got != $expected'
    #   at t/synopsis.t line 14.
    #   because:
    #          $got --> "1.0"
    #     $expected --> 1
    #
    not ok 4 - $got le $expected
    #   Failed test '$got le $expected'
    #   at t/synopsis.t line 15.
    #   because:
    #          $got --> "1.0"
    #     $expected --> 1
    #
    ok 5 - $got >= $expected
    # Looks like you failed 3 tests of 5.

In other words, this version of `ok' reports both that
the test that was done, and the values of the variables
involved that caused the test to fail.

The idea is that you can just write every test as: `ok EXPR', but you
now get useful error messages. This mostly eliminates the need for the
following functions from Test::More:

    # Can write...                   # Instead of...

    ok $got eq $expected;            is        $got, $expected;
    ok $got ne $unexpected;          isnt      $got, $unexpected;
    ok $got ~~ $expected;            is_deeply $got, $expected;
    ok $got =~ $pattern;             like      $got, $pattern;
    ok $got !~ $pattern;             unlike    $got, $pattern;
    ok $obj->isa($classname);        is_ok     $got, $classname;
    ok $obj->can($methodname);       can_ok    $obj, $methodna...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/T*

%changelog
