# BEGIN SourceDeps(oneline):
BuildRequires: perl(Async.pm) perl(HTTP/Parser.pm) perl(HTTP/Response.pm) perl(JSON/XS.pm) perl(LWP/UserAgent.pm) perl(Module/Build.pm) perl(Storable.pm)
# END SourceDeps(oneline)
%define module_name Test-HTTP-MockServer-Once
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.0.2
Release: alt1
Summary: Implement a one shot mock HTTP server for use in tests
Group: Development/Perl
License: apache
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/I/IG/IGIBBS/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
Based on the Test::HTTP::MockServer manpage but runs once and exits rather than 
continuing to run.

Sometimes, when writing a test, you don't have to opportunity to do
dependency injection of the type of transport used in a specific
API. Sometimes that code will unequivocally always use actual HTTP
and the only control you have is over the host and port to which it
will connect.

This class offers a simple way to mock the service being called. It
does that by binding to a random port or specified port on localhost.
Using a random port means that this can be used by tests running in 
parallel on the same host. Using a specified port means you can have a
predictable URL to give as a callback URL when testing OAuth2 and the 
like.

The socket will be bound and listened on the main test process, then 
closed after one request has been received. You will need to restart the 
server for each test call it should receive.

If you want a server to carry on running for multiple tests, see 
the Test::HTTP::MockServer manpage.

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README
%perl_vendor_privlib/T*

%changelog
