# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(Test/Builder.pm) perl(Test/More.pm) perl(Test/NoWarnings.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(YAML/Tiny.pm) perl(inc/Module/Install.pm) perl(lib/abs.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name Test-If
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Test only if ...
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MO/MONS/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Generic usage

    use Test::More;
    use Test::If 'Test::Something', [ tests => N ];
    
    # Is equal to
    
    use Test::More;
    eval q{ use Test::Something; 1 } or plan skip_all => 'Module Test::Something required for this test';
    plan tests => N;

    
    use Test::More;
    use Test::If sub { $ENV{TEST_AUTHOR} }, [ tests => N ];
    
    # Is equal to
    
    use Test::More;
    $ENV{TEST_AUTHOR} or plan skip_all => "Test condition not met";
    plan tests => N;

You can also combine options and it is allowed to omit plan options, if it is runned by loaded module or you want to load it manually

For example common `pod-coverage.t':

    use Test::More;
    use Test::If
        sub { $ENV{TEST_AUTHOR} },  # Checked first $ENV{TEST_AUTHOR}, otherwise skip
        'Test::Pod::Coverage 1.08', # Use Test::Pod::Coverage of at least version 1.08
        'Pod::Coverage 0.18',       # And want Pod::Coverage at least of version 0.18
    ;
    
    all_pod_coverage_ok();

If some of conditions will not be met, test will be skipped.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/T*

%changelog
