%define module_name Test-LWP-UserAgent
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN/Meta/Requirements.pm) perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(HTTP/Date.pm) perl(HTTP/Message/PSGI.pm) perl(HTTP/Request.pm) perl(HTTP/Request/Common.pm) perl(HTTP/Response.pm) perl(HTTP/Status.pm) perl(JSON/MaybeXS.pm) perl(LWP/UserAgent.pm) perl(Module/Metadata.pm) perl(Moose.pm) perl(Path/Tiny.pm) perl(Safe/Isa.pm) perl(Scalar/Util.pm) perl(Storable.pm) perl(Test/Deep.pm) perl(Test/Fatal.pm) perl(Test/More.pm) perl(Test/Needs.pm) perl(Test/RequiresInternet.pm) perl(Test/Warnings.pm) perl(Try/Tiny.pm) perl(URI.pm) perl(if.pm) perl(lib.pm) perl(namespace/clean.pm) perl(overload.pm) perl(parent.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.036
Release: alt1
Summary: a LWP::UserAgent suitable for simulating and testing network calls
Group: Development/Perl
License: perl
URL: https://github.com/karenetheridge/Test-LWP-UserAgent

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/E/ET/ETHER/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module is a subclass of the LWP::UserAgent manpage which overrides a few key
low-level methods that are concerned with actually sending your request over
the network, allowing an interception of that request and simulating a
particular response.  This greatly facilitates testing of client networking
code where the server follows a known protocol.

The synopsis describes a classic case where you want to test how your
application reacts to various responses from the server.  This module will let
you send back various responses depending on the request, without having to
set up a real server to test against.  This can be invaluable when you need to
test edge cases or error conditions that do not normally arise from the
server.

There are a lot of different ways you can set up the response mappings, and
hook into this module; see the documentation for the individual interface
methods.

You can use a the PSGI manpage app to handle the requests - see examples/call_psgi.t
in this dist, and also the register_psgi entry elsewhere in this document below.

OR, you can route some or all requests through the network as normal, but
still gain the hooks provided by this class to test what was sent and
received:

    my $useragent = Test::LWP::UserAgent->new(network_fallback => 1);

or:

    $useragent->map_network_response(qr/real.network.host/);

    # ... generate a request...

    # and then in your tests:
    is(
        $useragent->last_useragent->timeout,
        180,
        'timeout was overridden properly',
    );
    is(
        $useragent->last_http_request_sent->uri,
        'uri my code should have constructed',
    );
    is(
        $useragent->last_http_response_received->code,
        '200',
        'I should have gotten an OK response',
    );


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CONTRIBUTING Changes README docs examples
%perl_vendor_privlib/T*

%changelog
