%define module_version 0.08
%define module_name Test-MethodFixtures
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Class/Accessor/Fast.pm) perl(Data/Dump.pm) perl(Digest/MD5.pm) perl(File/Temp.pm) perl(Hook/LexWrap.pm) perl(Module/Build/Tiny.pm) perl(Path/Tiny.pm) perl(Scalar/Util.pm) perl(Storable.pm) perl(Test/Deep.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(base.pm) perl(strict.pm) perl(version.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.08
Release: alt1
Summary: Convenient mocking of externalities by recording and replaying method calls.
Group: Development/Perl
License: perl
URL: https://github.com/mjemmeson/Test-MethodFixtures

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MJ/MJEMMESON/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Record and playback method arguments, for convenient mocking in tests.

With this module it is possible to easily replace an expensive, external or
non-repeatable call, so that there is no need to make that call again during
subsequent testing.

This module aims to be low-dependency to minimise disruption with legacy
codebases.  By default tries to use the Test::MethodFixtures::Storage::File manpage to
record method data.  Other storage classes can be provided instead, to use
modules available to your system.

N.B. This module should be considered ALPHA quality and liable to change.

Despite not providing any test methods, it is under the `Test::' namespace to
aid discovery and because it makes little sense outside of a test environment.
The name is inspired by database 'fixtures'.

Feedback welcome!


%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes
%perl_vendor_privlib/T*

%changelog
