# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Scalar/Util.pm) perl(Test/Mimic/Generator.pm) perl(Test/Mimic/Library.pm) perl(Test/Mimic/Library/PlayArray.pm) perl(Test/Mimic/Library/PlayHash.pm) perl(Test/Mimic/Library/PlayScalar.pm) perl(Test/Mimic/Recorder.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.009007
%define module_name Test-Mimic
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.009007
Release: alt1
Summary: Perl module for automatic package and object mocking via recorded data.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/B/BR/BRENDAN/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Test::Mimic allows one to easily mock a package by first recording its behavior and then playing it back..All that is required is to use Test::Mimic prior to loading the real packages and then run the desired
program. The first run will be the recording phase and your program should behave normally. Subsequent runs
will use the recorded data to simulate the mimicked packages. This is the playback phase.

=over

=item Test::Mimic->import($preferences)

The $preferences hash reference passed to import is fairly simply and the majority of its structure can be
deduced from the synopsis above. Several of the elements themselves, however, require explanation.

'save' => a directory name where recorded data should be written/read from. The directory need
not exist.

'string' => a reference to a subroutine that accepts a single argument and returns it in a stringified form.
It should minimally handle non-reference scalars, array references, hash references and references to
scalars.

'destring' => a reference to a subroutine that is the inverse of the 'string' subroutine. For example,
is_deeply( $x, $preferences->{'destring'}->( $preferences->{'string'}->($x) ) ) from the Test::More module
should pass.

'key' => a reference to a subroutine that accepts a reference to an array of arguments and returns a hash key
based upon them. It is VITALLY IMPORTANT that you run Test::Mimic::Library::get_id on any argument before
examining its state. See the documentation for Test::Mimic::Library for more information.

'monitor_args' => a reference to a subroutine that accepts a reference to an array of arguments and begins
recording the desired ones. You will probably want to  use Test::Mimic::Library::monitor. Returns a
scalar that will later be passed to the subroutine keyed by 'play_args'.

'play_args' => a reference to a subroutine that accepts first a reference to an array of arguments and then
the scalar returned by the subroutine keyed by 'monitor_args'. It should hijack the desired arguments. You
will probably want to apply the soon to be written Test::Mimic::Library::hijack.

'scalars' => a reference to an array of package scalar names that you wish to record.

'key', 'monitor_args', and 'play_args' can be repeated at several levels of the hash. The most specific one
possible will be used in each case. Also, all subroutines, arrays and hashes in a package will be recorded.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/T*

%changelog
