%define module_name Test-MockPackages
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Const/Fast.pm) perl(English.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(FindBin.pm) perl(Lingua/EN/Inflect.pm) perl(List/Util.pm) perl(Scalar/Util.pm) perl(Storable.pm) perl(Sub/Metadata.pm) perl(Test/Deep.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test/Tester.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.01
Release: alt1
Summary: Mock external dependencies in tests
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/W/WE/WETERS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Test::MockPackages is a package for mocking other packages as well as ensuring those packages are being used correctly.

Say we have a Weather class that can return the current degrees in Fahrenheit. In order to do this it uses another class, Weather::Fetcher which
makes an external call. When we want to write a unit test for Weather, we want to mock the functionality of Weather::Fetcher.

Here is the sample code for our Weather class:

 package Weather;
 use Moose;
 use Weather::Fetcher;
 sub degrees_f {
     my ( $self, $zip_code ) = @_;

     my $data = eval { Weather::Fetcher::fetch_weather( $zip_code ) };
     if ( !$data ) {
         return;
     }

     return $data->{temp_f} . "-OF";
 }

And here's how we may choose to test this class. In the `success' subtest, we use the mock() helper subroutine, and in the `failure' method we use the OOP approach. Both provide identical functionality.

 use Test::More;
 use Test::MockPackages qw(mock);
 subtest 'degrees_f' => sub {
     subtest 'success' => sub {
         my $m = mock({
             'Weather::Fetcher' => {
                 fetch_weather => [
                    expects => [ '14202' ],
                    returns => [ { temp_f => 80 } ],
                 ],
             },
         });

         isa_ok( my $weather = Weather->new, 'Weather' );
         is( $weather->degrees_f( 14202 ), '80-OF', 'correct temperature returned' );
     };

     subtest 'failure' => sub {
         my $m = Test::MockPackages->new();
         $m->pkg( 'Weather::Fetcher' )
           ->mock( 'fetch_weather' )
           ->expects( '14202' )
           ->returns();

         my $weather = Weather->new;
         is( $weather->degrees_f( 14202 ), undef, 'no temperature returned' );
     };
 };
 done_testing();

When we run our tests, you can see that Test::MockPackages validates the following for us: 1. the subroutine is called with the correct arguments, 2. the subroutine was called the correct number of times. Lastly, Test::MockPackages allows us to have this mocked subr...
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc ignore.txt README Changes
%perl_vendor_privlib/T*

%changelog
