%define module_version 0.03
%define module_name Test-OpenID-Server
%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(HTTP/Server/Simple.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Net/OpenID/Server.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(Test/HTTP/Server/Simple.pm) perl(Test/OpenID/Consumer.pm) perl(Test/WWW/Mechanize.pm) perl(Test/Warnings.pm) perl(YAML/Tiny.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: setup a simulated OpenID server
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TS/TSIBLEY/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Test::OpenID::Server will provide a server to test your OpenID client
against.  To use it, do something like this:

   use Test::More tests => 1;
   use Test::OpenID::Server;
   my $server   = Test::OpenID::Server->new;
   my $url_root = $server->started_ok("server started ok");

Now you can run your OpenID tests against the URL in `$url_root'.  Identities
are any URL in the form of `$url_root . "/foo"'.  There is one special
identity: `/unknown'.  This identity will causes the OpenID server
to return a non-identity page (which will mean the OpenID client won't find an
identity).  Every other identity will return a successful authentication.


%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes
%perl_vendor_privlib/T*

%changelog
