# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(List/Compare.pm) perl(Moo.pm) perl(PAUSE/Packages.pm) perl(PAUSE/Permissions.pm) perl(Parse/LocalDistribution.pm) perl(Pod/Usage.pm) perl(Test/MockObject.pm) perl(Test/More.pm) perl(Test/Most.pm) perl(parent.pm) perl(strictures.pm)
# END SourceDeps(oneline)
%define module_version 0.003
%define module_name Test-PAUSE-ConsistentPermissions
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.003
Release: alt1
Summary: Check your PAUSE permissions are consistent in your distribution.
Group: Development/Perl
License: mit
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NE/NEWELLC/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module is designed to check the permissions of this distribution and ensure that they
are consistent.  This checks that for all the modules in the distribution the owner and comaintainer
are the same.

To perform your own checks in some way other than a simple test look at the 
the Test::PAUSE::ConsistentPermissions::Check manpage module.

Note that this is different to checking that the current author has permission to upload this module.

    use Test::More;
    use Test::PAUSE::ConsistentPermissions;

    all_permissions_consistent 'Test::PAUSE::ConsistentPermissions';

    done_testing;

These test will only run if the RELEASE_TESTING environment variable is set, otherwise they will
skip.

Note that missing permissions will not cause a test failure, but if you are
in verbose mode a note will be made.  This is because when you're doing a
release including new files those permissions will indeed not be found.

The success message will be subtly different when the permissions don't
exist for some of the modules you are about to upload.

For a script to check modules on CPAN see the pause-check-distro-perms manpage.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md README Changes LICENSE
%perl_vendor_privlib/T*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
