%define module_name Test-Prereq-Meta
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN/Meta.pm) perl(Carp.pm) perl(Exporter.pm) perl(ExtUtils/Manifest.pm) perl(File/Find.pm) perl(File/Glob.pm) perl(File/Spec.pm) perl(Module/Build.pm) perl(Module/CoreList.pm) perl(Module/Extract/Use.pm) perl(Module/Metadata.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(constant.pm) perl(lib.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.003
Release: alt1
Summary: Test distribution prerequisites against meta data.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/W/WY/WYANT/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This Perl module tests whether a Perl module or file's prerequisites are
all accounted for in the meta data for its distribution. It was inspired
by Brian D. Foy's Test::Prereq, and like it uses
Module::Extract::Use to determine what modules a
given Perl script/module needs. But unlike Test::Prereq
this module loads prerequisites from the distribution's meta data file
(hence this module's name) using CPAN::Meta, and is thus
independent of the distribution's build mechanism.

Each file tested has a test generated for each distinct module used. If
a file uses no modules, a skipped test is generated.

Note that this package requires Perl 5.10, a requirement it inherits
from Module::Extract::Use. If you are writing a
test that might be run under an older Perl, you would need to do
something like the following, which works if the prerequisite test is in
its own file:

 use Test::More 0.88; # For done_testing();
 
 "$]" >= 5.010
   or plan skip_all => 'Perl 5.10 or higher required';
 require Test::Prereq::Meta;
 Test::Prereq::Meta->import( 'prereq_ok' );
 
 prereq_ok();
 
 done_testing();

There are no exports by default, but anything so documented can be
exported, and export tag `:all' exports everything exportable.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/T*

%changelog
