# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Config.pm) perl(base.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Test-Random
%define upstream_version 20130427

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt2_9

Summary:    Make testing random functions deterministic
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Test/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Module/Build.pm)
BuildRequires: perl(Test/More.pm)
BuildArch:  noarch
Source44: import.info

%description
This is a testing module to make testing random things a bit more
deterministic.

Controlling randomness
    Its main function is to allow you to repeat a failing test in the same
    way it ran before, even if it contained random elements. Test::Random
    will output the seed used by the random number generator. You can then
    use this seed to repeat the last test with exactly the same random
    elements.

    You can control the random seed used by Test::Random by setting the
    'TEST_RANDOM_SEED' environment variable. This is handy to make test
    runs repeatable.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Build.PL installdirs=vendor

./Build

%check
./Build test

%install
./Build install destdir=%{buildroot}

%files
%doc Changes LICENSE META.json META.yml  README SIGNATURE
%perl_vendor_privlib/*

%changelog
