Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Test/CheckChanges.pm) perl(Test/CheckManifest.pm) perl(Test/Perl/Critic.pm) perl(Test/Prereq/Build.pm) perl(Test/Spelling.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Test-Regression
Version:        0.08
Release:        alt2_23
Summary:        Test library that can generate outputs and compare against them
License:        GPL+ or Artistic
URL:            https://metacpan.org/release/Test-Regression
Source0:        https://cpan.metacpan.org/modules/by-module/Test/Test-Regression-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(Module/Build.pm)
# Run-time:
BuildRequires:  perl(base.pm)
BuildRequires:  perl(FileHandle.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(Test/Builder/Module.pm)
BuildRequires:  perl(Test/Differences.pm)
BuildRequires:  perl(utf8.pm)
BuildRequires:  perl(warnings.pm)
# Tests:
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(DirHandle.pm)
BuildRequires:  perl(English.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(lib.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(Test/Builder/Tester.pm)
BuildRequires:  perl(Test/More.pm)
# Optional tests:
# Test::CheckChanges not used
# Test::CheckManifest not used
BuildRequires:  perl(Test/MockObject/Extends.pm)
# Test::Perl::Critic not used
# Test::Pod not used
# Test::Pod::Coverage not used
# Test::Prereq::Build not used
# Test::Spelling not used


Source44: import.info

%description
Using the various Test:: modules you can compare the output of a function
against what you expect. However if the output is complex and changes from
version to version, maintenance of the expected output could be costly.
This module allows one to use the test code to generate the expected
output, so that if the differences with model output are expected, one can
easily refresh the model output.

%prep
%setup -q -n Test-Regression-%{version}

%build
/usr/bin/perl Build.PL installdirs=vendor
./Build

%install
./Build install destdir=$RPM_BUILD_ROOT create_packlist=0
find $RPM_BUILD_ROOT -depth -type d -exec rmdir {} 2>/dev/null \;

# %{_fixperms} $RPM_BUILD_ROOT/*

%check
unset TEST_AUTHOR TEST_REGRESSION_GEN
./Build test

%files
%doc Changes README
%{perl_vendor_privlib}/*

%changelog
