# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Test-Reporter-Transport-Metabase
%define upstream_version 1.999010

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_5

Summary:    Metabase transport for Test::Reporter
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Test/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(CPAN/Testers/Report.pm)
BuildRequires: perl(Carp.pm)
BuildRequires: perl(Config/Perl/V.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Glob.pm)
BuildRequires: perl(File/Spec.pm)
BuildRequires: perl(JSON/MaybeXS.pm)
BuildRequires: perl(Metabase/Client/Simple.pm)
BuildRequires: perl(Metabase/User/Profile.pm)
BuildRequires: perl(Metabase/User/Secret.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Test/Reporter/Transport.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(warnings.pm)
BuildArch:  noarch
Source44: import.info

%description
This module submits a Test::Reporter report to the specified Metabase
instance.

This requires a network connection to the Metabase uri provided. If you
wish to save reports during offline operation, see the
Test::Reporter::Transport::File manpage. (Eventually, you may be able to
run a local Metabase instance to queue reports for later transmission, but
this feature has not yet been developed.)

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes LICENSE META.json META.yml  README
%perl_vendor_privlib/*

%changelog
