# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Dump.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Test/More.pm) perl(Test/Stream.pm) perl(Test/Stream/Bundle/V1.pm) perl(Test/Stream/Exporter.pm) perl(Test/Stream/Plugin/Compare.pm) perl(Test/Stream/Plugin/Core.pm) perl(Test/Stream/Plugin/SRand.pm) perl(constant.pm) perl(lib.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_version 0.001001
%define module_name Test-Stream-Plugin-Explain-Terse
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001001
Release: alt1
Summary: Dump anything in a single line in 80 characters or fewer
Group: Development/Perl
License: perl
URL: https://github.com/kentnl/Test-Stream-Plugin-Explain-Terse

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/K/KE/KENTNL/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module aims to provide a simple tool for adding trace-level details
about data-structures to the TAP stream to visually keep track of what is being
tested.

Its objective is to not be comprehensive, and only be sufficient for a quick
visual sanity check, allowing you to visually spot obviously wrong things at a
glance without producing too much clutter.

It is expected that if `Explain::Terse' produces a data structure that needs
compacting for display, that the user will also be performing sub-tests on that
data structure, and those sub-tests will trace their own context closer to the
actual test.

  # Checking: { a_key => ["a value"], b_key => ["b value'], ... }
    # Subtest: c_key is expected
    # Checking: ["c value"]
    ok 1 - c_key's array has value "c value"
    1..1
  ok 1 - c_key is expected

The idea being the higher up in the data structure you're doing the comparison,
the less relevant the individual details are to that comparison, and the actual
details only being relevant in child comparisons.

This is obviously also better if you're doing structurally layered comparison,
and not simple path-based comparisons, e.g:

  # Not intended to be used this way.
  note explain_terse(\%%hash);
  is( $hash{'key'}{'otherkey'}{'finalkey'}, 'expected_value' );

And you want something like:

  note explain_terse(\%%hash);
  ok( exists $hash{'key'}, 'has q[key]')
    and subtest "key structure" => sub {

      my $structure = $hash{'key'};
      note explain_terse($structure);
      is( ref $structure, 'HASH', 'is a HASH' )
        and ok( exists $structure->{'otherkey'}, 'has q[otherkey]' )
        and subtest "otherkey structure" => sub {

          my $substructure = $structure->{'otherkey'};
          note explain_terse($substructure);
          is( ref $substructure, 'HASH', 'is a HASH' )
            and ok( exists $structure->{'finalkey'}, 'has final key' )
            and subtest "finalkey structure" => sub {

              my $final_structure = $substructure->{'finalkey'};
              note e...
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes
%perl_vendor_privlib/T*

%changelog
