%define module_name Test-Subtest-Attribute
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Attribute/Handlers.pm) perl(English.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Test/Builder.pm) perl(Test/More.pm) perl(Test/TestCoverage.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: Declare subtests using subroutine attributes
Group: Development/Perl
License: perl
URL: https://github.com/bmarcotte/Test-Subtest-Attribute

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BM/BMARCOTTE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module provides a simple way, using a subroutine attribute called `:Subtest', to declare normal subroutines to be subtests in a test script.

Subtests are typically declared using a call to the `subtest()' function from the Test::More manpage, in one of the two following ways:

  subtest 'name1'  => sub { ... };  # An anonymous sub
  subtest 'name 2' => \&some_named_sub;

The first way can quickly lead to long anonymous subs that can present issues when looking at stacktraces for debugging, profiling, logging, etc.
The second way usually leads to repeating the same, or similar, names for each subtest subroutine, in addition to declaring the sub itself, e.g.:

  subtest 'test_this' => \&test_this;
  subtest 'test_that' => \&test_that;
  ...
  sub test_this { ... }
  sub test_that { ... }
  ...

This module lets you declare those subtests without calls to the `subtest()' function, by simply adding a `:Subtest' attribute to any
subroutine that you'd like to have executed as a subtest, like so:

  sub subtest_name1 :Subtest {
    ...
  }

That declares a subtest named 'name1' (the subtest_ part of the name, if present, is automatically stripped off).

If you'd like to specify the name of the subtest explicitly, which is handy if you'd like to use a name that includes characters. such as spaces,
that aren't allowed in bareword identifiers, you can do so by providing an argument to the `:Subtest' attribute like so:

  sub some_named_sub :Subtest('name 2') {
    ...
  }

When you're done declaring subtests, you run all the ones you've queued up by calling `subtests()-'run()>.

From this module, most test scripts will only need to use the `:Subtest' attribute and the `run()' method described below.
Most of the other methods described below are for more advanced usage, such as in test modules that might want to conditionally
add, remove, or otherwise manipulate the subtests managed herein.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE CHANGES
%perl_vendor_privlib/T*

%changelog
