# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Module/Build.pm) perl(Test/Builder.pm) perl(Test/Builder/Module.pm) perl(Test/More.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name Test-Subtests
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Different kinds of subtests.
Group: Development/Perl
License: open_source
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/B/BA/BATLOCK/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Different kinds of tests, that allow for some subtests to fail.

    use Test::More;
    use Test::Subtests;

    one_of  'one_of fail'  => sub { ok(1); ok(1); ok(0); };
    one_of  'one_of pass'  => sub { ok(1); ok(0); ok(0); };

    none_of 'none_of fail' => sub { ok(1); ok(1); ok(0); };
    none_of 'none_of pass' => sub { ok(0); ok(0); ok(0); };

    some_of 'some_of fail' => sub { ok(0); ok(0); ok(0); };
    some_of 'some_of pass' => sub { ok(1); ok(1); ok(0); };

    all_of  'all_of fail'  => sub { ok(1); ok(1); ok(0); };
    all_of  'all_of pass'  => sub { ok(1); ok(1); ok(1); };

    most_of 'most_of fail' => sub { ok(1); ok(0); ok(0); };
    most_of 'most_of pass' => sub { ok(1); ok(1); ok(0); };

    ignore  'ignore pass'  => sub { ok(0); ok(0); ok(0); };
    ignore  'ignore pass'  => sub { ok(1); ok(1); ok(0); };
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/T*

%changelog
