%define module_version 0.005
%define module_name Test-Tabs
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(FindBin.pm) perl(Test/Builder.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.005
Release: alt1
Summary: check the presence of tabs in your project
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Test-Tabs

Source0: http://cpan.org.ua/authors/id/T/TO/TOBYINK/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module scans your project/distribution for any perl files (scripts,
modules, etc) for the presence of tabs.

In particular, it checks that all indentation is done using tabs, not
spaces; alignment is done via spaces, not tabs; indentation levels
never jump up (e.g. going from 1 tab indent to 3 tab indent without an
intervening 2 tab indent); and there is no trailing whitespace on any
line (though lines may consist entirely of whitespace).

Comment lines and pod are ignored. (A future version may also ignore
heredocs.)

A trailing comment `##WS' can be used to ignore all whitespace
rules for that line. `## no Test::Tabs' can be used to begin ignoring
whitespace rules for all following lines until `## use Test::Tabs' is
seen. `## skip Test::Tabs' tells Test::Tabs to skip the current file,
but it must be used *before* the first whitespace rule violation.


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE TODO COPYRIGHT Changes README
%perl_vendor_privlib/T*

%changelog
