# BEGIN SourceDeps(oneline):
BuildRequires: perl(AnyEvent/Handle.pm) perl(ExtUtils/MakeMaker.pm) perl(IO/Handle.pm) perl(Scalar/Util.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.03
%define module_name Test-Tarantool
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: The Swiss army knife for tests of Tarantool related Perl and lua code.
Group: Development/Perl
License: open_source
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/R/RE/REZNIKOV/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
use Test::Tarantool;
    use AnyEvent;

    # Clear data and exit on Ctrl+C.
    my $w = AnyEvent->signal (signal => "INT", cb => sub { exit 0 });

    my @shards = map {
        my $n = $_;
        Test::Tarantool->new(
            host => '127.17.3.0',
            spaces => 'space[0] = {
                           enabled = 1,
                           index = [ {
                               type = HASH,
                               unique = 1,
                               key_field = [ { fieldno = 0, type = STR }, ],
                           }, ],
                       }',
            initlua => do {
                          open my $f, '<', 'init.lua';
                          local $/ = undef;
                          <$f> or "";
                       },
            on_die => sub { warn "Shard #$n unexpectedly terminated\n"; exit; },
        );
    } 1..4;

    my @cluster = map { [ $_->{host}, $_->{p_port} ] } @shards;

    {
        my $cv = AE::cv();
        $cv->begin for (@shards);
        $_->start($cv) for (@shards);
        $cv->recv;
    }

    {
        $_->sync_start() for (@shards);
    }

    {
        my ($status, $reason) = $shards[0]->sync_ro();
        die $reason unless $status;
        print (($shards[0]->sync_admin_cmd("show info"))[1]);
    }

    # Some test case here

    $shards[1]->pause();

    # Some test case here

    $shards[1]->resume();

    {
        my ($status, $reason) = $shards[0]->sync_rw();
        die $reason unless $status;
        print (($shards[0]->sync_admin_cmd("show info"))[1]);
    }

    # stop tarantools and clear work directoies
    @shards = ();
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/T*

%changelog
