Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Perl and RPM versioning don't work the same :-(
%global extraversion 02

# Provides/Requires filtering is different from rpm 4.9 onwards
%global rpm49 1

Name:		perl-Test-Unit-Lite
Epoch:		1
Version:	0.12
Release:	alt2_45
Summary:	Unit testing without external dependencies
License:	GPL+ or Artistic
URL:		https://metacpan.org/release/Test-Unit-Lite
Source0:	https://cpan.metacpan.org/modules/by-module/Test/Test-Unit-Lite-%{version}%{?extraversion}.tar.gz
BuildArch:	noarch
# Module Build
BuildRequires:	coreutils
BuildRequires:	rpm-build-perl
BuildRequires:	perl-devel
BuildRequires:	perl(Module/Build.pm)
# Module Runtime
BuildRequires:	perl(base.pm)
BuildRequires:	perl(Carp.pm)
BuildRequires:	perl(Cwd.pm)
BuildRequires:	perl(Exporter.pm)
BuildRequires:	perl(File/Basename.pm)
BuildRequires:	perl(File/Copy.pm)
BuildRequires:	perl(File/Find.pm)
BuildRequires:	perl(File/Path.pm)
BuildRequires:	perl(File/Spec.pm)
BuildRequires:	perl(strict.pm)
BuildRequires:	perl(Symbol.pm)
BuildRequires:	perl(warnings.pm)
# Test Suite
BuildRequires:	perl(Error.pm)
BuildRequires:	perl(lib.pm)
BuildRequires:	perl(Taint/Runtime.pm)
# Dependencies

# Filter unwanted provides and requires (rpm 4.9 onwards)


Source44: import.info
%filter_from_provides /^perl(Test.Unit.\(Debug\|HarnessUnit\|Result\|TestCase\|TestRunner\|TestSuite\).pm)/d
%filter_from_requires /^perl(Test.Unit.Test\(Runner\|Suite\).pm)/d

%description
This framework provides a lighter version of Test::Unit framework. It
implements some of the Test::Unit classes and methods needed to run test
units. Test::Unit::Lite tries to be compatible with public API of
Test::Unit. It doesn't implement all classes and methods at 100% and only
those necessary to run tests are available.

%prep
%setup -q -n Test-Unit-Lite-%{version}%{?extraversion}

# Filter unwanted provides and (prior to rpm 4.9)
# Unwanted requires not actually detected prior to rpm 4.9
%if ! %{rpm49}
%global provfilt /bin/sh -c "%{__perl_provides} | grep -Evx 'perl\\(Test::Unit::(Debug|HarnessUnit|Result|TestCase|TestRunner|TestSuite)\\)'"
%global __perl_provides %{provfilt}
%endif

%build
perl Build.PL --installdirs=vendor
./Build

%install
./Build install --destdir=%{buildroot} --create_packlist=0
# %{_fixperms} -c %{buildroot}

%check
./Build test

%files
%if 0%{?_licensedir:1}
%doc --no-dereference LICENSE
%else
%doc LICENSE
%endif
%doc Changes README
%{perl_vendor_privlib}/Test/

%changelog
