%define module_name Test-VariousBits
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Acme/Magic8Ball.pm) perl(Devel/Comments.pm) perl(Devel/TraceLoad/Hook.pm) perl(Devel/Unplug.pm) perl(ExtUtils/MakeMaker.pm) perl(GD.pm) perl(Module/Mask.pm) perl(Module/Util.pm) perl(Smart/Comments.pm) perl(Sub/Delete.pm) perl(Sub/Identify.pm) perl(Test.pm) perl(Test/Weaken.pm) perl(Test/Without/Module.pm) perl(lib.pm) perl(vars.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 8
Release: alt1
Summary: Various test helpers.
Group: Development/Perl
License: gpl
URL: http://user42.tuxfamily.org/test-variousbits/index.html

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/K/KR/KRYDE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module overrides the Perl core functions

    shmget()
    shmread()
    shmwrite()
    shmctl()

to pretend that their System-V style shared memory is either not implemented
or there's not enough memory.

This fakery can be used for testing to check how module code etc might
behave on a system without shm or when there's not enough memory.  A module
might throw an error, use an I/O fallback, etc.

The shm functions are overridden using the `CORE::GLOBAL' mechanism (see
the OVERRIDING CORE FUNCTIONS entry in the CORE manpage) so `Test::Without::Shm' must be loaded
before compiling any code which might call them.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes COPYING
%perl_vendor_privlib/T*
%perl_vendor_privlib/M*

%changelog
