%define module_name Test2-Harness-Renderer-JUnit
# BEGIN SourceDeps(oneline):
BuildRequires: perl(App/Yath/Tester.pm) perl(Carp.pm) perl(Cwd.pm) perl(Data/Dumper.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(Storable.pm) perl(Test/More.pm) perl(Test2/API.pm) perl(Test2/Harness/Renderer.pm) perl(Test2/Harness/Util/HashBase.pm) perl(Test2/Plugin/NoWarnings.pm) perl(Test2/Tools/Explain.pm) perl(Test2/V0.pm) perl(XML/Generator.pm) perl(XML/Simple.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators
BuildRequires: /usr/bin/yath

Name: perl-%module_name
Version: 1.000005
Release: alt1
Summary: Captures Test2::Harness results and emits a junit xml file.
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TO/TODDR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
`Test2::Harness::Renderer::JUnit' provides JUnit output formatting sufficient
to be parsed by Jenkins and hopefully other junit parsers.

This code borrows many ideas from `TAP::Formatter::JUnit' but unlike that module
does not provide a method to emit a different xml file for every testcase.
Instead, it defaults to emitting to a single junit.xml to whatever the directory
was you were in when you ran yath. This can be overridden by setting the
`JUNIT_TEST_FILE' environment variable

Timing information is included in the JUnit XML since this is native to `Test2::Harness'

In standard use, "passing TODOs" are treated as failure conditions (and are
reported as such in the generated JUnit).  If you wish to treat these as a
"pass" and not a "fail" condition, setting `ALLOW_PASSING_TODOS=1' in your
environment will turn these into pass conditions.

The JUnit output generated was developed to be used by Jenkins
(https://jenkins.io/).  That's the build tool we use at the
moment and needed to be able to generate JUnit output for.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes
%perl_vendor_privlib/T*

%changelog
