%define module_name Test2-Tools-LoadModule
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN/Meta.pm) perl(Carp.pm) perl(Exporter.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(Getopt/Long.pm) perl(Module/Build.pm) perl(Module/Metadata.pm) perl(Net/Cmd.pm) perl(Pod/Usage.pm) perl(Test2/API.pm) perl(Test2/API/Context.pm) perl(Test2/Plugin/BailOnFail.pm) perl(Test2/Tools/EventDumper.pm) perl(Test2/Util.pm) perl(Test2/V0.pm) perl(if.pm) perl(lib.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.008
Release: alt1
Summary: Test whether a module can be successfully loaded.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/W/WY/WYANT/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This Test2::Tools module tests whether a module can be
loaded, and optionally whether it has at least a given version, and
exports specified symbols. It can also skip tests, or skip all tests,
based on these criteria.

Test2::Manual::Testing::Migrating
deals with migrating from Test::More to
Test2::V0. It states that instead of `require_ok()' you
should simply use the `require()' built-in, since a failure to load the
required module or file will cause the test script to fail anyway. The
same is said for `use_ok()'.

In my perhaps-not-so-humble opinion this overlooks the fact that if you
can not load the module you are testing, it may make sense to abort not
just the individual test script but the entire test run. Put another
way, the absence of an analogue to Test::More's
`require_ok()' means there is no analogue to

 require_ok( 'My::Module' ) or BAIL_OUT();

This module restores that functionality.

Note that if you are using this module with testing tools that are
not based on Test2::V0 you may have to tweak the load order
of modules. I ran into this in the early phases of implementation, and
fixed it for my own use by initializing the testing system as late as
possible, but I can not promise that all such problems have been
eliminated.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/T*

%changelog
