# BEGIN SourceDeps(oneline):
BuildRequires: perl(Devel/Cycle.pm) perl(ExtUtils/MakeMaker.pm) perl(PadWalker.pm) perl(Test2/API.pm) perl(Test2/V0.pm)
# END SourceDeps(oneline)
%define module_name Test2-Tools-MemoryCycle
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Check for memory leaks and circular memory references
Group: Development/Perl
License: perl
URL: https://metacpan.org/pod/Test2::Tools::MemoryCycle

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PL/PLICEASE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Perl's garbage collection has one big problem: Circular references can't get cleaned up.
The above example is the sort of thing that sometimes trips me up, where a code reference
inside a data structure refers to another part of the data structure.  There already
exists a good testing module to find these sort of problems: the Test::Memory::Cycle manpage,
so why write this one?  Well that module uses the Test::Builder manpage, and this one instead uses
the Test2::API manpage.  If you want to write the Test2::Suite manpage tests without pulling in the Test::Builder manpage
then this is the cycle testing module for you.

This module also uses the standard the Exporter manpage interface, instead of letting you specify
a test plan.  That behavior was once in vogue I guess, but I do not care for it.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README author.yml LICENSE Changes
%perl_vendor_privlib/T*

%changelog
