%define module_name Test2-Tools-PerlCritic
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/Tiny.pm) perl(ExtUtils/MakeMaker.pm) perl(Path/Tiny.pm) perl(Perl/Critic.pm) perl(Perl/Critic/Policy.pm) perl(Perl/Critic/Utils.pm) perl(Ref/Util.pm) perl(Test2/API.pm) perl(Test2/V0.pm) perl(experimental.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.08
Release: alt1
Summary: Testing tools to enforce Perl::Critic policies
Group: Development/Perl
License: perl
URL: https://metacpan.org/pod/Test2::Tools::PerlCritic

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PL/PLICEASE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Test for the Perl::Critic manpage violations using the Test2 manpage.  Although this testing tool
uses the the Test2 manpage API instead of the older the Test::Builder manpage API, the primary
motivation is to provide output in a more useful form.  That is policy violations
are grouped by policy class, and the policy class name is clearly displayed as
a diagnostic.  The author finds the former more useful because he tends to address
one type of violation at a time.  The author finds the latter more useful because
he tends to want to lookup or adjust the configuration of the policy as he is
addressing violations.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README author.yml
%perl_vendor_privlib/T*

%changelog
