%define module_version 0.011
%define module_name TestLink-API
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Class/Inspector.pm) perl(Clone.pm) perl(Data/Validate/URI.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(MIME/Base64.pm) perl(Pod/Coverage/TrustPod.pm) perl(Pod/Wordlist.pm) perl(Prompt/Timeout.pm) perl(Scalar/Util.pm) perl(Test/CPAN/Changes.pm) perl(Test/EOL.pm) perl(Test/Fatal.pm) perl(Test/Kwalitee.pm) perl(Test/More.pm) perl(Test/NoTabs.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test/Spelling.pm) perl(Test/Synopsis.pm) perl(Test/Version.pm) perl(XMLRPC/Lite.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.011
Release: alt1
Summary: Provides an interface to TestLink's XMLRPC api
Group: Development/Perl
License: perl
URL: https://github.com/teodesian/TestLink-Perl

Source0: http://cpan.org.ua/authors/id/T/TE/TEODESIAN/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
`TestLink::API' provides methods to access an existing TestLink account.  You can then do things like look up tests, set statuses and create builds from lists of tests.
The getter methods cache the test tree up to whatever depth is required by your getter calls.  This is to speed up automated creation/reading/setting of the test db based on existing automated tests.
Cache expires at the end of script execution. (TODO memcache controlled by constructor, with create methods invalidating cache?)
Getter/setter methods that take args assume that the relevant project/testsuite/test/plan/build provided exists (TODO: use cache to check exists, provide more verbose error reason...), and returns false if not.
Create methods assume desired entry provided is not already in the DB (TODO (again): use cache to check exists, provide more verbose error reason...), and returns false if not.
It is by no means exhaustively implementing every TestLink API function.  Designed with TestLink 1.9.9, but will likely work on (some) other versions.
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/T*

%changelog
