# BEGIN SourceDeps(oneline):
BuildRequires: perl(AutoLoader.pm) perl(Carp.pm) perl(Cwd.pm) perl(Env.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(FileHandle.pm) perl(Getopt/Long.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 1.10
%define module_name Text-EP3
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.10
Release: alt1
Summary: The Extensible Perl PreProcessor
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MY/MYKL/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
EP3 is a Perl5 program that preprocesses STDIN or some set 
of input files and produces an output file. 
EP3 only works on input files and produces output files. It seems to me that
if you want to preprocess arrays or somesuch, you should be using perl.
EP3 was first developed to provide
a flexible preprocessor for the Verilog hardware
description language. Verilog presents some problems that 
were not easily solved by using cpp or m4. I wanted to be
able to use a normal preprocessor, but extend its functionality. 
So I wrote EP3 - the Extensible Perl PreProcessor. The main
difference between EP3 and other preprocessors is its built-in
extensibility. Every directive in EP3 is really a method defined
in EP3, one of its submodules, or embedded in the file that is 
being processed. By linking the directive name
to the associated methods, other methods could
be added, thus extending the preprocessor.

Many of the features of EP3 can be modified via command line switches. For
every command line switch, there is an also accessor method. 

=over 4

=item Directives and Method Invocation

Directives are preceded with the a user 
defined delimeter. The default delimeter is `@'. This 
delimeter was chosen to avoid conflicts with other 
preprocessor delimeters (`#' and the Verilog backtick), 
as well as Verilog syntax that might be found a the 
beginning of a line (`$', `&', etc.). A directive is 
defined in Perl as 
the beginning of the line, any amount of whitespace, 
and the delimeter immediately followed by Perl word 
characters (0-9A-Za-z_).

EP3 looks for directives, strips off the delimeter, and then 
invokes a method of the same name. The standard 
directives are defined within the EP3 program. Library 
or user defined directives may be loaded as perl 
modules either via the use command or from a command 
line switch for inclusion at the 
beginning of the EP3 run. Using the "include" directive 
coupled with the "perl_begin/end" directives 
perl subroutines (and hence 
EP3 directives) may be dynamically included during 
the EP3 run.

=item Directive Extension Method 1: The use command.

A module may be included with the use statement provided that it pushes its
package name onto EP3's @ISA array (thus telling EP3 to inherit its methods).
For a Verilog module whose filename is Verilog.pm and has the package name
Text::EP3::Verilog, the following line must be included ...

    push (@Text::EP3::ISA, qw(Text::EP3::Verilog));

This package can then be simply included in whatever script you are using to
call EP3 with the line:

    use Text::EP3::Verilog;

All methods within the module are now available to EP3 as directives.

=item Directive Extension Method 2: The command line switch.

A module can be included at run time with the -module modulename switch on the
command line (assuming the ep3_parse_command_line method is invoked). The
modulename is assumed to have a .pm extension and exist somewhere in the
directories specified in @INC. 
All methods within the module are now available to EP3 as directives.

=item Directive Extension Method 3: The ep3_modules accessor method.

Modules can be added by using the accessor method ep3_modules. 

    $preprocessor->ep3_modules("module1","module2", ....);

All methods within the module are now available to EP3 as directives.

=item Directive Extension Method 4: Embedded in the source code or included files.

Using the perl_begin and perl_end directives to delineate perl sections,
subroutines can be declared (as methods) anywhere in a processed file or in a
file that the process file includes. In this way, runtime methods are made
available to EP3. For example ...

    1 Text to be printed ...
    @perl_begin
    sub hello {
        my $self = shift;
        print "Hello there\n";
    }
    @perl_end
    2 Text to be printed ...
    @hello
    3 Text to be printed ...
    
    would result in
    1 Text to be printed ...
    2 Text to be printed ...
    Hello there 
    3 Text to be printed ...

Using this method, libraries of directives can be built and included with the
include directive (but it is recommended that they be moved into a module when
they become static).


=item Input Files and Processing

Input files are processed one line at a time. The 
EP3 engine attempts to perform substitutions with 
elements stored in macro/define/replace lists. All directive 
lines are preprocessed before being evaluated (the only 
exception being the key portions of the if[n]def and 
define directives). Directive lines can be extended 
across multiple lines by placing the `\' character at the 
end of each line. Comments are normally protected 
from the preprocessor, but protection can be 
dynamically turned off and then back on. From a 
command line switch, comments can also be deleted 
from the output.


=item Output Files

EP3 typically writes output to Perl's STDOUT, but 
can be assigned to any output file. EP3 can also be run 
in "dependency check" mode via a command line 
switch. In this mode, normal output is suppressed, and 
all dependent files are output in the order accessed.
NOTE! EP3 uses the select call to change the default output
file for included perl blocks. However, if you are using 
a method invocation of ep3, note that the default output
for the rest of your script will be changed as well. 
(This can be easily worked with, but should be known beforehand).

Most parameters can be modified before invoking EP3 including
directive string, comment delimeters, comment protection
and inclusion, include path, and startup defines.

=back

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/T*
%perl_vendor_privlib/auto/*
%files scripts
%_bindir/*

%changelog
