# BEGIN SourceDeps(oneline):
BuildRequires: perl(AutoLoader.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Text/EP3.pm)
# END SourceDeps(oneline)
%define module_version 1.00
%define module_name Text-EP3-Verilog
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.00
Release: alt1
Summary: Verilog extension for the EP3 preprocessor.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/G/GS/GSPIVEY/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module is an EP3 extension for the Verilog Hardware Description Language.

=over 4 

=item The signal directive

@signal key definition
Take a list of signals and generate signal lists in the differing formats
that Verilog uses.
This is accomplished by formatting a list of new defines and then calling
the EP3 define method
For example, the following command: 

_@signal KEY a[3:0], b, c[width:0], etc.

will cause the following to be done:

_Define KEY with the list as it appears (can be used in further signal defs)
_Define KEY{SIG} with the signal list (can be used in port lists)
   _e.g. replace KEY{SIG} with  a[3:0], b, c[width:0]
_Define KEY{EVENT} with the reg list  (To be used in event lists)
   _e.g. replace KEY{EVENT} with a or b or c
_Define KEY{IN}  with the input list (you supply the first input and the trailing ';'
   _e.g. replace KEY{INPUT} with [3:0] a;\ninput b;\ninput[width:0] c
   _or ... make the line 
   _input KEY{INPUT}; become ..
   _input [3:0] a;
   _input b;
   _input [width:0] c;
_Define KEY{OUT} with the output list (output [] sig).
   _e.g. like KEY{IN}
_Define KEY{INOUT}  with the inout list (inout [] sig).
   _e.g. like KEY{IN}
_Define KEY{WIRE} with the wire list (wire [] sig).
   _e.g. like KEY{IN}
_Define KEY{REG} with the reg list (reg [] sig).
   _e.g. like KEY{IN}
_Define KEY{DSP} with the printf list (sig=%%0[b|x] depending on width).
   _e.g. replace KEY{DSP} with a=%%0x, b=%%0b, c=%%0x
   _This can be used in the $display task
      _$display("KEY{DSP}",KEY{SIG});

If the module and the test bench default is set up properly, the user needs
only enter the signals in one place in the module file. This section can be
included conditionally (e.g. @include "file" PORT) in the test bench and the
signals can be automatically generated in the correct format in whichever
header they are used. This means that a user can produce a module and its test
bench by simply filling in the port list, the behavioral code, and the
stimulus (which is of course, the real work). All of the signal header crud
can be taken care of automagically.

=item The step directive 

@step number [command]
The step directive is useful to save verbage in test benches. @step 5 command;
generates the following code:

_repeat 5 @ (posedge tclk); command;

The posdege can be changed to '' or negedge (or whatever) using the edgetype
directive. The tclk can be changed using the edgename directive.

=item The edgename directive

@edgename name
The edgename directive allows the user to change the name used in the step
directive. The default is 'tclk'.

=item The edgetype directive

@edgetype type
The edgetype directive allows the user to change the type used in the step
directive. The default is 'posedge'.

=item The denum directive

@denum key, key, [value], key, ...
denum works like the ep3 enum, except that it generates
verilog define statements. It also replaces KEY anywhere
in the text with `KEY so that the verilog defines will work.
(e.g. @denum orange, blue, green     will generate:

_`define orange 0
_`define blue 0
_`define green 0
_@define orange `orange
_@define blue `blue
_@define green `green


=back


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/T*
%perl_vendor_privlib/auto/*

%changelog
