%define _without_test 1
%define module_version 0.02
%define module_name Text-Filter-Chain
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: object for chaining Text::Filter objects and running
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/W/WI/WIMV/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
=over 4

=item new()

Returns a new empty `Text::Filter::Chain' object. Optionally, an 
ordered array of filters can be specified by passing a `filters' 
argument to new(). All filters are checked using is_valid_filter().

=item add_filter($filter)

Adds the filter object $filter to the end of the array of filters. 
The filter is checked using is_valid_filter().

=item is_valid_filter($filter)

Checks whether $filter is a valid filter for inclusion in a 
`Text::Filter::Chain'. The following requirements need to be met:

=over 2

=item 

a set_input() method must be available for setting the filter input;

=item 

a set_output() method must be available for setting the filter output;

=item 

a run() method must be available which runs the filter on its entire input.

=back

Note that $filter does not need to be a `Text::Filter' or derived object. 
However, deriving at least the final filter in the chain from `Text::Filter'
adds the benefit of automagical output buffer creation (see run()).

=item set_input()

Sets the arguments which will be passed to the set_input() method of 
the first filter in the chain in run().

=item set_output()

Sets the arguments which will be passed to the set_output() method of
the final filter in the chain in run().

=item run()

Runs all filters in the chain. This means that the run() method will be 
invoked on each filter object, and that the data will be buffered in 
between the filter: the output of the first filter is written to an array, 
which is used as the input of the 2nd filter, and so on. 

If set_input() was invoked on the chain, these arguments will be passed 
to the set_input() method of the first filter in the chain. 
If this is not the case, the input of the first filter must have been 
defined in some other way, or run() will fail during the processing
of the first filter.

If set_output() was invoked on the chain, these arguments will be passed 
to the set_output() method of the final filter in the chain. 
If this is not the case, the output of the final filter must have been 
defined in some other way, or run() will fail during the processing
of the final filter.

However, a fallback is provided for filters derived from the 
`Text::Filter' class. If no output is specified for the final filter, 
and no chain output is given, the chain output will
default to an empty array before processing all filters. 
This array is accessible as the 1st element in the ref to array kept 
in the `output' field of the chain.

=back


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/T*

%changelog
