# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Moose.pm) perl(Net/FTP.pm) perl(Socket.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 0.03
%define module_name Text-Format-Interview
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Take a text interview transcript and format to html.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/Z/ZA/ZARQUON/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
use Text::Format::Interview;

 my $txt = Text::Format::Interview->new();
 my $html = $txt->process($string);


Converts text of the form:

  # Interview between Fred Flintstone and Barney Rubble, 3rd April, 2000 BC

  Fred: [00:00:00]
  So, Barney, when did you decide to become a Flintstone?

  Barney: [00:00:10]
  Well Fred, I'm not actually a Flintstone, my surname is Rubble and I live in Bedrock.

Into HTML, something like:

  # Interview between Fred Flintstone and Barney Rubble, 3rd April, 2000 BC

  <h2>Fred: [00:00:00]</h2>
  <p>So, Barney, when did you decide to become a Flintstone?</p>

This is intended as a pre-processor, so the header is using markdown here, but could equally be html.

Alternatively if you specify a comma separated list of "interviewers" and
"interviewees" at the top of the file to be processed, you'll get some css
classes as well:

  # Interview between Fred Flintstone and Barney Rubble, 3rd April, 2000 BC
  interviewer: fred,wilma
  interviewee: barney,betty

  Fred: [00:00:00]
  So what's it like to be a flintstone?

  Barney: [00:00:05]
  I'm not a Flintstone, I'm a Rubble.  What do you think Betty?

  Betty:  [00:00:10]
  Yes Fred, you're confused.

  Wilma:  [00:00:15]
  I'm so terribly embarrassed by my husband.

Which ought to render to:

  # Interview between Fred Flintstone and Barney Rubble, 3rd April, 2000 BC

  <p>interviewer: fred, wilma <br>
  interviewee: barney, betty <br></p>

  <h2 class="interviewer">Fred: [00:00:00]</h2>
  <p>So what's it like to be a flintstone?</p>

  <h2 class="interviewee">Barney: [00:00:05]</p>
  <p>I'm not a Flintstone, I'm a Rubble.  What do you think Betty?</p>

This gives us the ability to put pretty colours in the interview transcript
with CSS, something like this:

  h2.interviewer > p { color: red }

(or something far more tortorous if you need to Internet Explorer 6 support ...)


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/T*

%changelog
