# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Encode.pm) perl(File/Basename.pm) perl(File/Copy.pm) perl(File/DirCompare.pm) perl(File/Path.pm) perl(File/Spec.pm) perl(File/Spec/Functions.pm) perl(File/Temp.pm) perl(Module/Build.pm) perl(Test/Differences.pm) perl(Text/Diff.pm) perl(URI.pm)
# END SourceDeps(oneline)
%define module_version 2.16
%define module_name Text-Frundis
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.16
Release: alt1
Summary: object interface for the frundis markup language
Group: Development/Perl
License: open_source
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AN/ANASETO/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
`frundis' intends to be a semantic markup language with a roff-like syntax for
supporting authoring of a variety of light to medium weight documents, from
novels to technical tutorials.

The documentation of the `frundis' tool and `frundis' language are maintained
as the mdoc manual pages frundis(1) and frundis_syntax(5), respectively. This
man page describes the module interface.

`Text::Frundis' provides the following methods:

=over

=item process_source(%%opts)

This function processes frundis source from an UTF-8 encoded file, a decoded
string, or reads from standard input. The %%opts hash accepts the following keys:

=over

=item input_file

The name of an input file.

=item input_string

The name of a decoded string.

=item target_format

The format to produce. Can be `xhtml', `epub' or `latex'.

=item standalone

Produce a complete document. It is implied by `epub' target format, and
`xhtml' target format unless `all_in_one_file' is specified.

=item all_in_one_file

Boolean flag that, in case of exporting to `xhtml', specifies that output
should be a single file.

=item output_file

The name of an output file or directory. A directory when exporting to `epub'
or `xhtml' (unless `all_in_one_file' is specified for the last one).

=back

=item add_macro($macro_name, $code)

Add an user defined macro for a posterior `process_source' invocation, with
name $macro_name and code $code, where $code is a coderef that takes an object
as first argument, that accepts methods described in frundis_syntax(5).  Works
as a `de -perl' in frundis source, except that @Arg isn't exported by
`Text::Frundis'.

=item add_filter($tag_name, $code)

Add an user defined filter for a posterior `process_source' invocation, with
tag $tag_name and code $code, where $code is a coderef that takes an object as
first argument, that accepts methods described in frundis_syntax(5). Works as a
`X ftag -code' in frundis source, except that @Arg isn't exported by
`Text::Frundis'.

=back

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes docs examples
%perl_vendor_privlib/T*

%files scripts
%_bindir/*

%changelog
