Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Alien/Hunspell.pm) perl-podlators
# END SourceDeps(oneline)
%define fedora 38
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		perl-Text-Hunspell
Version:	2.16
Release:	alt2_7
Summary:	Perl interface to the Hunspell library
License:	GPL-1.0-or-later OR Artistic-1.0-Perl
Url:		http://search.cpan.org/dist/Text-Hunspell/
Source0:	https://cpan.metacpan.org/modules/by-module/Text/Text-Hunspell-%{version}.tar.gz
Patch1:		Text-Hunspell-2.15-no-Alien.patch
# Module Build
BuildRequires:	coreutils
BuildRequires:	findutils
BuildRequires:	gcc-c++
BuildRequires:	hunspell-utils libhunspell-devel
BuildRequires:	perl-devel
BuildRequires:	rpm-build-perl
BuildRequires:	perl-devel
BuildRequires:	perl(ExtUtils/MakeMaker.pm)
BuildRequires:	perl(ExtUtils/PkgConfig.pm)
BuildRequires:	sed
# Module Runtime
BuildRequires:	perl(DynaLoader.pm)
BuildRequires:	perl(vars.pm)
# Test Suite
%if 0%{?fedora} > 23 || 0%{?rhel} > 7
BuildRequires:	glibc-locales
%endif
BuildRequires:	hunspell-en
BuildRequires:	perl(Data/Dumper.pm)
BuildRequires:	perl(strict.pm)
BuildRequires:	perl(Test/More.pm)
BuildRequires:	perl(Test/Pod.pm)
BuildRequires:	perl(warnings.pm)
# Dependencies
# (none)

# Don't "provide" private Perl libs

Source44: import.info

%description
This module provides a Perl interface to the Hunspell library. This module
is to meet the need of looking up many words, one at a time, in a single
session, such as spell-checking a document in memory.

%prep
%setup -q -n Text-Hunspell-%{version}

# We don't have (nor need) Alien::Hunspell, so revert to using ExtUtils::PkgConfig
%patch1 

# Fix up shellbang in example
sed -i -e 's|^#!/usr/bin/env perl|#!/usr/bin/perl|' examples/basic.pl

%build
perl Makefile.PL INSTALLDIRS=vendor OPTIMIZE="%{optflags}"
%make_build

%install
make pure_install DESTDIR=%{buildroot}
find %{buildroot} -type f -name .packlist -delete
find %{buildroot} -type f -name '*.bs' -empty -delete
# %{_fixperms} -c %{buildroot}

%check
LANG=en_US make test TEST_POD=1 TEST_VERBOSE=1

%files
%doc --no-dereference LICENSE
%doc Changes README examples/
%{perl_vendor_archlib}/auto/Text/
%{perl_vendor_archlib}/Text/

%changelog
