%define module_name Text-KnuthPlass
# BEGIN SourceDeps(oneline):
BuildRequires: libsowing-devel perl(Class/Accessor.pm) perl(ExtUtils/CBuilder.pm) perl(JSON/Syck.pm) perl(Module/Build.pm) perl(PDF/Builder.pm) perl(Pod/Simple/HTML.pm) perl(Test/More.pm) perl(Text/Hyphen.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.07
Release: alt2
Summary: Breaks paragraphs into lines using the TeX algorithm
Group: Development/Perl
License: perl
URL: https://metacpan.org/pod/Text::KnuthPlass

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PM/PMPERRY/%{module_name}-%{version}.tar.gz

%description
use Text::KnuthPlass;
    my $typesetter = Text::KnuthPlass->new();
    my @lines = $typesetter->typeset($paragraph);
    ...

To use with plain text:

    for (@lines) {
        for (@{$_->{nodes}}) {
            if ($_->isa("Text::KnuthPlass::Box")) { print $_->value }
            elsif ($_->isa("Text::KnuthPlass::Glue")) { print " " }
        }
        if ($_->{nodes}[-1]->is_penalty) { print "-" }
        print "\n";
    }

To use with PDF::API2:

    my $text = $page->text;
    $text->font($font, 12);
    $text->lead(13.5);

    my $t = Text::KnuthPlass->new(
        measure => sub { $text->advancewidth(shift) }, 
        linelengths => [235]
    );
    my @lines = $t->typeset($paragraph);

    my $y = 500;
    for my $line (@lines) {
        $x = 50; 
        for my $node (@{$line->{nodes}}) {
            $text->translate($x,$y);
            if ($node->isa("Text::KnuthPlass::Box")) {
                $text->text($node->value);
                $x += $node->width;
            } elsif ($node->isa("Text::KnuthPlass::Glue")) {
                $x += $node->width + $line->{ratio} *
                    ($line->{ratio} < 0 ? $node->shrink : $node->stretch);
            }
        }
        if ($line->{nodes}[-1]->is_penalty) { $text->text("-") }
        $y -= $text->lead();
    }


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md LICENSE Changes examples
%perl_vendor_archlib/T*
%perl_vendor_autolib/*

%changelog
