Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Text-Levenshtein
Version:        0.15
Release:        alt1_7
Summary:        Implementation of the Levenshtein edit distance
License:        GPL+ or Artistic
URL:            https://metacpan.org/release/Text-Levenshtein
Source0:        https://cpan.metacpan.org/authors/id/N/NE/NEILB/Text-Levenshtein-%{version}.tar.gz
BuildArch:      noarch
# Build
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Runtime
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(List/Util.pm)
BuildRequires:  perl(Unicode/Collate.pm)
# Tests only
BuildRequires:  perl(lib.pm)
BuildRequires:  perl(open.pm)
BuildRequires:  perl(parent.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(utf8.pm)
Requires:       perl(Unicode/Collate.pm) >= 1.040
Source44: import.info

%description
This module implements the Levenshtein edit distance. The Levenshtein edit
distance is a measure of the degree of proximity between two strings. This
distance is the number of substitutions, deletions or insertions ("edits")
needed to transform one string into the other one (and vice versa). When
two strings have distance 0, they are the same. To learn more about the
Levenshtein metric, have a look at the Wikipedia page
<http://en.wikipedia.org/wiki/Levenshtein_distance>.

%prep
%setup -q -n Text-Levenshtein-%{version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}
# %{_fixperms} %{buildroot}/*

%check
%{make_build} test

%files
%doc --no-dereference LICENSE
%doc Changes README
%{perl_vendor_privlib}/*

%changelog
