# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Slurp.pm) perl(FileHandle.pm) perl(Module/Build.pm) perl(Test/More.pm) perl(Text/Aligner.pm) perl(YAML/Tiny.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define module_version 0.05
%define module_name Text-LookUpTable
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.05
Release: alt1
Summary: Perl5 module for text based look up table operations
Group: Development/Perl
License: perl
URL: http://search.cpan.org/dist/Text-LookUpTable/

Source0: http://cpan.org.ua/authors/id/J/JE/JERI/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Text::LookUpTable provides operations for creating, storing, displaying,
plotting, loading, and querying a *look up table* structure.  The format
of the stored structure is designed to be visually easy to understand
so that it can be easily edited using a text editor.

The authors inteded use of this library is to allow a user to edit a
text file representation of a look up table which can then be loaded
in to an embedded controller such as MegaSquirt [http://www.msextra.com].
Additional code would be needed to convert this generic structure
to whatever application specific format is required.

What is a *look up table* and how is it different than a *table*?
A *look up table* is commonly used in embedded controllers to avoid the
use of costly floating pointing operations by looking up a value based
on the input coordiantes.  A function with two inputs (f(x, y)) which
would use floating point operations can be represented (with some loss
in precsion) as a table.

In contrast a *table* (or spreadsheet) has any number of columns/rows.
The columns can be of different types.  And a table does not try to represent
any sort of function, it just stores data.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes doc
%perl_vendor_privlib/T*

%changelog
