# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(List/MoreUtils.pm) perl(List/Util.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name Text-Pangram
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: utilities to find English pangrams
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/J/JE/JESTER/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
A pangram is a text that contains every letter of the alphabet. This
module provides utilities for identifying pangrams.

=over

=item $pangram->new

Constructor. Receives the text that will be analyzed.

=back

=over

=item $pangram->is_pangram

Returns true if the supplied text is a pangram.

=back

=over

=item $pangram->find_pangram_window

Finds the shortest "pangrammatic window" in a text: the shortest
span of text that contains a pangram. It is designed to be fast when
scanning large texts. 

The method will return false if the text does not contain a pangram at
all. If the text is pangrammatic, `$pangram' will allow you to access
three pieces of data:

=back

=over

=item $pangram->window_length

The length of the shortest pangrammatic window.

=back

=over

=item $pangram->window

The pangrammatic window from the original text.

=back

=over

=item $pangram->stripped_window

The stripped text of the pangrammatic window. (That is, with all
nonalphabetic characters stripped out.)

=back
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/T*

%changelog
