%define module_name Text-Parser
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Benchmark.pm) perl(Devel/Cover/Report/Codecov.pm) perl(Dist/Zilla/Plugin/Test/TidyAll.pm) perl(English.pm) perl(Exception/Class.pm) perl(ExtUtils/MakeMaker.pm) perl(FileHandle.pm) perl(FindBin.pm) perl(Import/Into.pm) perl(List/MoreUtils.pm) perl(List/Util.pm) perl(Moose.pm) perl(Moose/Exporter.pm) perl(Moose/Role.pm) perl(Moose/Util.pm) perl(Moose/Util/TypeConstraints.pm) perl(MooseX/ClassAttribute.pm) perl(MooseX/CoverableModifiers.pm) perl(MooseX/StrictConstructor.pm) perl(Pod/Coverage/TrustPod.pm) perl(Pod/Elemental/Transformer/List.pm) perl(Pod/Weaver/Section/Contributors.pm) perl(Scalar/Util.pm) perl(String/Index.pm) perl(String/Util.pm) perl(Test/CPAN/Changes.pm) perl(Test/CPAN/Meta.pm) perl(Test/Exception.pm) perl(Test/Kwalitee.pm) perl(Test/MinimumVersion.pm) perl(Test/More.pm)
BuildRequires: perl(Test/Output.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Text/CSV.pm) perl(Throwable/Error.pm) perl(Try/Tiny.pm) perl(constant.pm) perl(feature.pm) perl(lib.pm) perl(namespace/autoclean.pm) perl(parent.pm) perl(strict.pm) perl(utf8.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.000
Release: alt1
Summary: Bundles common text reading tasks. Stop re-writing mundane code to parse your next text file. This ...
Group: Development/Perl
License: perl
URL: https://github.com/balajirama/Text-Parser

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BA/BALAJIRAM/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
`Text::Parser' is a bare-bones text parsing class. It is actually ignorant of the text format, and cannot recognize any grammars, but derived classes that inherit from it can specify this. They can do this by overriding some of the methods in this class.

Future versions are also expected to include progress-bar support. All these software features are text-format independent and can be re-used in parsing any text format. Thus derived classes of `Text::Parser' will be able to take advantage of these features without having to re-write the code again.

At present this class handles files as input. You could either give filenames or filehandles (`GLOB's) as input to the parser. In the future the class may include the ability to read from other input sources. This will be especially useful if you have a series of files/sockets to read from.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CODE_OF_CONDUCT.md LICENSE README.PATCHING README Changes CONTRIBUTING.md
%perl_vendor_privlib/T*

%changelog
