# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exception/Class.pm) perl(ExtUtils/MakeMaker.pm) perl(Module/Build.pm) perl(Module/Signature.pm) perl(Readonly.pm) perl(Socket.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 1.03
%define module_name Text-Printf
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.03
Release: alt1
Summary: A simple, lightweight text fill-in class.
Group: Development/Perl
License: unrestricted
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/R/RO/ROODE/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
There are many templating modules on CPAN.  They're all far, far more
powerful than Text::Printf.  When you need that power, they're
wonderful.  But when you don't, they're overkill.

This module provides a very simple, lightweight, quick and easy
templating mechanism for when you don't need those other
powerful-but-cumbersome modules.

There are two ways to use this module: an immediate (printf-like)
way, and a delayed (prepared) way.

For the immediate way, you simply call the tprintf entry elsewhere in this document or the tsprintf entry elsewhere in this document
with a boilerplate string and the values to be inserted/formatted.
See the following section for information on how to format the
boilerplate string.  This is somewhat easier than using plain
`printf' or `sprintf', since the name of the value to be inserted is
at the same place as its format.

For the prepared way, you create a template object that contains the
boilerplate text.  Again, see the next section for information on how
to format it properly.  Then, when it is necessary to render the final
text (with placeholders filled in), you use the the fill entry elsewhere in this document method,
passing it one or more references of hashes of values to be
substituted into the original boilerplate text.  The special value
`$DONTSET' indicates that the keyword (and its delimiters) are to
remain in the boilerplate text, unsubstituted.

That's it.  No flow control, no executable content, no filesystem
access.  Never had it, never will.


%prep
%setup -n %{module_name}-%{module_version}
rm -f t/[0-9][-_]signature.t t/[0-9][0-9][-_]signature.t t/[0-9]signature.t t/[0-9][0-9]signature.t t/signature.t
rm -f t/[0-9][-_]Signature.t t/[0-9][0-9][-_]Signature.t t/[0-9][0-9][0-9][-_]Signature.t t/[0-9]Signature.t t/[0-9][0-9]Signature.t t/[0-9][0-9][0-9]Signature.t t/Signature.t
rm -f t/[0-9][-_]manifest.t t/[0-9][0-9][-_]manifest.t t/[0-9][0-9][0-9][-_]manifest.t t/[0-9]manifest.t t/[0-9][0-9]manifest.t t/[0-9][0-9][0-9]manifest.t t/manifest.t
rm -f t/[0-9][-_]MANIFEST.t t/[0-9][0-9][-_]MANIFEST.t t/[0-9][0-9][0-9][-_]MANIFEST.t t/[0-9]MANIFEST.t t/[0-9][0-9]MANIFEST.t t/[0-9][0-9][0-9]MANIFEST.t t/MANIFEST.t

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/T*

%changelog
