%define module_name Text-Query
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(re.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.09
Release: alt2
Summary: Query processing framework
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JO/JONJ/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module provides an object that matches a data source
against a query expression.

Query expressions are compiled into an internal form when a new object is created 
or the `prepare' method is 
called; they are not recompiled on each match.

The class provided by this module uses four packages to process the query.
The query parser parses the question and calls a query expression
builder (internal form of the question). The optimizer is then called
to reduce the complexity of the expression. The solver applies the expression
on a data source. 

The following parsers are provided:

=over 4

=item Text::Query::ParseAdvanced

=item Text::Query::ParseSimple

=back

The following builders are provided:

=over 4

=item Text::Query::BuildAdvancedString

=item Text::Query::BuildSimpleString

=back

The following solver is provided:

=over 4

=item Text::Query::SolveSimpleString

=item Text::Query::SolveAdvancedString

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README ChangeLog
%perl_vendor_privlib/T*

%changelog
