# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(FileHandle.pm) perl(Test/More.pm) perl(Text/Similarity.pm) perl(Text/Similarity/Overlaps.pm) perl(WWW/Wikipedia.pm) perl(encoding.pm)
# END SourceDeps(oneline)
%define module_version 0.06
%define module_name Text-SenseClusters-LabelEvaluation
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: Module for evaluation of labels of the clusters.
Group: Development/Perl
License: gpl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/A/AA/AANANDJHA/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This Program will compare the result obtained from the SenseClusters with that 
	of Gold Standards. Gold Standards will be obtained from two independent and 
	reliable source:
			1. Wikipedia
			2. Wordnet
			
	For fetching the Wikipedia data it use the WWW::Wikipedia module from the CPAN 
	and for comparison of Labels with Gold Standards it uses the Text::Similarity
	Module. The comparison result is then further processed to obtain the result
	and score of result.
			


Result:

   a) Decision Matrix:	
	         Based on the similarity comparison of Labels with the gold standards,
	         the decision matrix are calculated as below:

	For eg:
	===========================================================================
			 	|	Cluster0	|	Cluster1	|		Row Total
	---------------------------------------------------------------------------
	Topic#1		|		271 	|		2713 	|			2984
	---------------------------------------------------------------------------
	Topic#2		|		2396 	|		306 	|			2702
	---------------------------------------------------------------------------
	Col Total	|		2667	|		3019	|			5686
	===========================================================================

	b) Calculated decision Matrix:	
	         Now based on decision matrix, a new calculated matrix is printed. 
	         Each of the cell in the matrix, will contains the probabilities value:
			
				CELL_VALUE_IN_DECISION_MATRIX / TOTAL_SCORE_OF_DECISION_MATRIX
			
		
	For eg:
		For cell : Cluster0 - Topic#1   
			i) First -Value = 271 / 5686 = 0.048


	         Now based on above decision matrix, new calculated matrix is: 
	========================================================================
				|	Cluster0		|	Cluster1	
	------------------------------------------------------------------------
	Topic#1		|	0.048 			|	0.477
	------------------------------------------------------------------------
	Topic#2		|	0.421 			|	0.054
	------------------------------------------------------------------------


	c) Interpreting Calculated decision Matrix:	
		
			1. Row-Wise Comparison
				For each topic, "row score" will be compared and cluster with maximum 
				value will be assigned to that topic.
				for eg: 
					a) Topic#1  	Cluster1     (max-row-score = 0.477 )
				 	b) Topic#2  	Cluster0     (max-row-score = 0.421 )
				 	
			2. Col-Wise Comparison
				For each Cluster, "col score" will be compared and topic with maximum 
				value will be assigned to that Cluster.
				for eg: 
					a) Cluster0  	Topic#2     (max-col-score = 0.421 )
				 	b) Cluster1  	Topic#1     (max-col-score = 0.477 )

	d)	Deriving final conclusion from above two comparison:
		
		Result of Row-Wise comparison and Column-wise comparison is matched.
		Only matching result is then printed.

		For eg:
			1. Row-Wise Comparison
				 a) Topic#1  	Cluster1 
				 b) Topic#2  	Cluster0 
			2. Col-Wise Comparison
				 a) Cluster0  	Topic#2    
				 b) Cluster1  	Topic#1 

		Matching Result: 
				Cluster0 	Topic#2
				Cluster1 	Topic#1   

	e) Overall score:
			This is the multiplication of all the probability scores of all
			matching cluster and topics.
			
			For eg:
				The score for above example will be: 0.201
			 
			



%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/T*

%changelog
