%define module_name Text-Starfish
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.39
Release: alt1
Summary: A Perl-based System for Text-Embedded
Group: Development/Perl
License: artistic
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/V/VL/VLADO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
(The documentation is probably not up to date.).
Starfish is a system for Perl-based text-embedded programming and
preprocessing, which relies on a unifying regular expression rewriting
methodology.  If you know Perl and php, you probably know the basic
idea: embed Perl code inside the text, execute it is some way, and
interleave the output with the text.   Very similar projects exist and
some of them are listed in the section on "SEE ALSO".  Starfish is, however,
unique in several ways.  One important difference between `starfish'
and similar programs (e.g. php) is that the output does not
necessarily replace the code, but it follows the code by default.
It is attempted with Starfish to provide a universal text-embedded
programming language, which can be used with different types of
textual files.

There are two files in this package: a module (Starfish.pm) and a
small script (starfish) that provides a command-line interface to the
module.  The options for the script are described in subsection
"the starfish_cmd list of file names and options entry elsewhere in this document".

The earlier name of this module was SLePerl (Something Like ePerl),
but it was changed it to `starfish' -- sounds better and easier to
type.  One option was `oyster,' but some people are thinking
about using it for Perl beans, and there is a (yet another) Perl
module for embedded Perl `Text::Oyster', so it was not used.

The idea with the ``starfish'' name is: the Perl code is embedded into
a text, so the text is equivalent to a shellfish containing pearls.
A starfish comes by and eats the shellfish...  Unlike a natural
starfish, this `starfish' is interested in pearls and does not
normally touch most of the surrounding meat.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %module_name


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc LICENSE report.pdf README.md README ChangeLog
%perl_vendor_privlib/T*

%files scripts
%_bindir/*

%changelog
