# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Config.pm) perl(Convert/Number/Armenian.pm) perl(Cwd.pm) perl(Encode.pm) perl(Exporter.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(Test/More.pm) perl(Test/More/UTF8.pm) perl(Test/Warn.pm) perl(XML/LibXML.pm) perl(XML/LibXML/XPathContext.pm) perl(YAML/Tiny.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 1.9
%define module_name Text-TEI-Markup
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.9
Release: alt1
Summary: a transcription markup syntax for TEI XML
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/A/AU/AURUM/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
TEI XML is a wonderful thing. The elements defined therein allow a
transcriber to record and represent just about any feature of a text that
he or she encounters.

The problem is the transcription itself. When I am transcribing a
manuscript, especially if that manuscript is in a bunch of funny characters
on the keymap for another language, I do not want to be switching back and
forth between keyboard layouts in order to type "<tag attr="attr>"
arrow-arrow-arrow-arrow-arrow "</tag> every six seconds. It's prone to
typo, it's astonishingly slow, and it makes my wrists hurt just to think
about it. I also don't really want to fire up an XML editor, select the
words or characters that need to be tagged, and click a lot. That way is
not prone to typo, but it's still pretty darn slow, and it makes my wrists
hurt even more to think about.

Text::TEI::Markup is my solution to that problem. It defines a bunch of
single- or double-character sigils that represent tags. These are a lot
faster and easier to type; I don't have to worry about typos; and I can do
it all with a plain text editor, thus minimizing use of the mouse.

I have tried to pick sigils that don't conflict with characters that are
found in manuscripts. I have succeeded for my particular set of
manuscripts, but I have not succeeded for the general case. If you like the
idea behind this module, you are still almost guaranteed to hate the sigils
I've picked. That's okay; you can re-define them.


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README CHANGES
%perl_vendor_privlib/T*

%changelog
