%define module_name Text-Table-Read-RelationOn-Tiny
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(autodie.pm) perl(strict.pm) perl(version.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.3.5
Release: alt1
Summary: Read binary "relation on (over) a set" from a text table.
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AA/AAHAZRED/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
This module implements a class that reads a binary *relation on a set*
(*homogeneous relation*, see
https://en.wikipedia.org/wiki/Binary_relation#Homogeneous_relation) from a
text table.

The table format must look like this:


   | x\y     | this | that | foo bar |
   |---------+------+------+---------+
   | this    | X    |      | X       |
   |---------+------+------+---------+
   | that    |      |      | X       |
   |---------+------+------+---------+
   | foo bar |      | X    |         |
   |---------+------+------+---------+

=over

=item *

Tables are read by method `get', see below.

=item *

Only two different table entries are possible, these are `X' and the empty
string (this is default and can be changed, see description of `new').

=item *

The entry in the table's upper left corner is simply ignored and may be empty,
but you cannot ommit the upper left `|' character.

=item *

The hotizontal rules are optional.

=item *

There is not something like a format check for the horizontal rules. Any line
starting with `|-' is simply ignored, regardless of the other subsequent
characters, if any.

=item *

The entries (names) in the header line are the set's element names. One of
these names may be the empty string.


=item *

The names of the columns (header line) and the rows (first entry of each row)
need to be the same and they must be unique, but they don't have to appear in the
same order.

=item *

Spaces at the beginning of a line are ignored.

=back



%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/T*

%changelog
