# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CPAN.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(FileHandle.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Socket.pm) perl(Test/More.pm) perl(YAML.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name	 Text-Tags
%define upstream_version 0.04

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_12

Summary:	Perl module to parse "folksonomy" space-separated tags
License:	GPL+ or Artistic
Group:		Development/Perl
Url:		https://metacpan.org/release/%{upstream_name}
Source0:	https://cpan.metacpan.org/modules/by-module/Text/%{upstream_name}-%{upstream_version}.tar.bz2


BuildRequires: perl(inc/Module/Install.pm)
BuildArch:  noarch
Source44: import.info

%description
Parses "folksonomies", which are 
simple space-or-comma-separated-but-optionally-quoted tag lists.

Specifically, tags can be any string, as long as they don't contain both a 
single and a double quote. Hopefully, this is a pretty obscure restriction. 
In addition, all whitespace inside tags is normalized to a single space 
(with no leading or trailing whitespace).

In a tag list string, tags can optionally be quoted with either single or 
double quotes. There is no escaping of either kind of quote, although you 
can include one type of quote inside a string quoted with the other. Quotes 
can also just be included inside tags, as long as they aren't at the 
beginning; thus a tag like joe's can just be entered without any extra quoting.
Tags are separated by whitespace and/or commas, though quoted tags can run into
each other without whitespace. Empty tags (put in explicitly with "" or '') are
ignored. (Note that commas are not normalized with whitespace, and can be 
included in a tag if you quote them.)

Why did the previous paragraph need to be so detailed? Because 
Text::Tags::Parser always successfully parses every line. That is, every single
tags line converts into a list of tags, without any error conditions. For 
general use, you can just understand the rules as being separate tags with 
spaces or commas, and put either kind of quotes around tags that need to have 
spaces.


%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build

%check
%{__make} test

%install
%makeinstall_std

%files
%doc Changes README
%{perl_vendor_privlib}/Text




%changelog
