# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_name Text-Template-Tiny
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.000.1
Release: alt1
Summary: Variable substituting template processor
Group: Development/Perl
License: perl
URL: https://github.com/sciurius/perl-Text-Template-Tiny

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JV/JV/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This is a very small and limited template processor. The only thing it
can do is substitute variables in a text.

Often that is all you need :-).

Example:

    use Text::Template::Tiny;

    # Create a template processor, with preset subtitutions.
    my $xp = Text::Template::Tiny->new(
      home    => $ENV{HOME},
      lib     => {
_      dev => "/tmp/mylib",
_      std => "/etc/mylib",
_  },
      version => 1.02,
    );

    # Add some more substitutions.
    $xp->add( app => "MyApp" );

    # Apply it.
    print $xp->expand(<<EOD);
    For [%% app %%] version [%% version %%], the home of all operations
    will be [%% home %%], and the library is [%% lib.std %%].
    EOD

    # Same, with additional substitutions for this call only.
    print $xp->expand( <<EOD, { app => "ThisApp" } );
    For [%% app %%] version [%% version %%], the home of all operations
    will be [%% home %%], and the library is [%% lib.std %%].
    EOD

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes
%perl_vendor_privlib/T*

%changelog
