%define module_name Text-TokenStream
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(List/Util.pm) perl(Module/Build/Tiny.pm) perl(Moo.pm) perl(Moo/Role.pm) perl(Test/Fatal.pm) perl(Test/More.pm) perl(Test/Warnings.pm) perl(Type/Library.pm) perl(Type/Utils.pm) perl(Types/Common/Numeric.pm) perl(Types/Path/Tiny.pm) perl(Types/Standard.pm) perl(namespace/clean.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: lexer to break text up into user-defined tokens
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AR/ARC/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This class is part of a collection of classes that act together to *lex*
(aka *scan*) an input text into a stream of *tokens*.

This *token stream* class provides the stream interface, along with a notion
of the "current position" in the input text, and position-aware error
reporting. It composes the Text::TokenStream::Role::Stream manpage; that role lists
the methods this class provides (so that you can easily write a parser
class that `has' a token stream which in turn `handles'
the tokenizer methods).

The basic lexer machinery is found in the Text::TokenStream::Lexer manpage; it is
separated out from the token stream so that it can be reused across many
inputs.

Tokens are instances of a class, the Text::TokenStream::Token manpage by default.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes
%perl_vendor_privlib/T*

%changelog
