%define module_name Text-vCard-Precisely
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Section/Simple.pm) perl(Data/UUID.pm) perl(Data/Validate/URI.pm) perl(Encode.pm) perl(List/Util.pm) perl(MIME/Base64.pm) perl(Module/Build/Tiny.pm) perl(Moose.pm) perl(Moose/Util/TypeConstraints.pm) perl(MooseX/Types/DateTime.pm) perl(MooseX/Types/Email.pm) perl(Path/Tiny.pm) perl(Test/More.pm) perl(Text/Diff.pm) perl(Text/LineFold.pm) perl(Text/vFile/asData.pm) perl(URI.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.28
Release: alt1
Summary: Read, Write and Edit the vCards 3.0 and/or 4.0 precisely
Group: Development/Perl
License: perl
URL: https://github.com/worthmine/Text-vCard-Precisely

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/W/WO/WORTHMINE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
A vCard is a digital business card. vCard and Text::vFile::asData
provide an API for parsing vCards
This module is forked from Text::vCard
because some reason bellow:

=over

=item

Text::vCard doesn't provide full methods based on RFC2426

=item

Mac OS X and iOS can't parse vCard4.0 with UTF-8 precisely. they cause some Mojibake

=item

Android 4.4.x can't parse vCard4.0


=item

I wanted to learn Moose, of course

=back

To handle an address book with several vCard entries in it, start with
Text::vFile::asData and then come back to this module.

Note that the vCard RFC requires version() and full_name().  This module does not check or warn yet if these conditions have not been met


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes LICENSE
%perl_vendor_privlib/T*

%changelog
