%define module_name Text-vFile-toXML
%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Socket.pm) perl(Test/More.pm) perl(Text/vFile/asData.pm) perl(XML/Quick.pm) perl(XML/SemanticDiff.pm) perl(YAML.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.05
Release: alt1
Summary: Convert vFiles into equivalent XML
Group: Development/Perl
License: bsd
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/K/KU/KULP/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module converts iCalendar (iCal : generically, vFile) files into their
(equivalent) XML (xCalendar / xCal) representation, according to Royer's IETF
Draft (http://tools.ietf.org/html/draft-royer-calsch-xcal-03).

    # Enable functional interface
    use Text::vFile::toXML qw(to_xml);

    # Input filename
    my $arg = "input.file";
    my $a = Text::vFile::toXML->new(filename => $arg)->to_xml;
    my $b = Text::vFile::toXML->new(filehandle =>
        do { open my $fh, $arg or die "can't open ics: $!"; $fh }
    )->to_xml;

    use Text::vFile::asData; # to make the functional example work
    my $data =
        Text::vFile::asData->new->parse(
            do {
                open my $fh, $arg
                    or die "Can't open vFile: $!"; $fh
                }
            );
    my $c = Text::vFile::toXML->new(data => $data)->to_xml;

    # Use functional interface
    my $d = to_xml($data);

    # Now ($a, $b, $c, $d) all contain the same XML string.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/T*

%changelog
