Epoch: 1
%define module_name TextFileParser
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exception/Class.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/CPAN/Changes.pm) perl(Test/CPAN/Meta.pm) perl(Test/Exception.pm) perl(Test/Kwalitee.pm) perl(Test/MinimumVersion.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Try/Tiny.pm) perl(parent.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.204
Release: alt2
Summary: an extensible Perl class to parse any text file by specifying grammar in derived classes.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BA/BALAJIRAM/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use strict;
    use warnings;
    use TextFileParser;

    my $parser = new TextFileParser;
    $parser->read(shift @ARGV);
    print $parser->get_records, "\n";

The above code reads a text file and prints the content to `STDOUT'.

Here's another parser which is derived from `TextFileParser' as the base class. See how simple it is to make your own parser.

    use strict;
    use warnings;
    package WordCounter;
    use parent 'TextFileParser';
    use Exception::Class (
        'SomeException' => {
            description => 'Some description',
            alias => 'throw_some_error'
        }
    );

    sub save_record {
        my ($self, $line) = @_;
        my (@words) = split /\s+/, $line;
        throw_some_error 
            error => $self->filename . ': expected at least one character: ' . $self->lines_parsed
                if not @words;
        $self->SUPER::save_record(\@words);
    }

    package main;
    use Data::Dumper qw(Dumper);
    use Try::Tiny;

    try {
        my $a_parser = new WordCounter;
        $a_parser->read(shift @ARGV);
        print Dumper($a_parser->get_records);
    } catch {
        print STDERR $_, "\n";
    };

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/T*

%changelog
